function [A, bins, density, vFnkt] = MCNLpdf(M, plot)
%
%
% Aufruf:  [A, bins, density, vFnkt] = MCNLpdf(M, plot)
%
%
% Die vorliegende Funktion berechnet die Verteilung der Makette
%
% A = arctan( (M2+M3)/M1 )
%
% mit Hilfe der MONTE-CARLO-METHODE !!
% 
% Die Mae M2, M3, M1 sind dabei wie folgt verteilt:
% M3 ist N(0.5, (1/10)^2)-verteilt
% M2 ist gleichverteilt im Intervall [3/8, 5/8]
% M1 ist dreiecksverteilt im Intervall [5/6, 7/6]
%
% Eingabeparameter:    M        Anzahl der Monte-Carlo-Simulationen
%
%                      plot     0, falls Histogramm nicht dargestellt werden soll
%
% Ausgabeparameter:    A    berechnete A-Werte (aufsteigend geordnet)
%
%                      bins     berechnete Klassenmitten (max 50, min 5)
%
%                      density  Werte der Verteilungsdichte (rel. Hufigkeiten in Klasse/M)
%
%                      vFnkt    Werte der empirischen Verteilungsfunktion
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 04.12.2003


% Vorinitialisierungen

mu = 1/2; sigma = 0.1;           % Verteilungsparameter
gyu = 3/8; gyo = 5/8;
gzu = 5/6; gzo = 7/6;


A = [];                          % Werte fr die Schliemae

rand('state',sum(100*clock));    % Zufallsgenerator initialisieren

for k=1:M                        % Zahl der Iterationen
    M3 = normrndB(mu,sigma);     % Wert von M3
    M2 = unifrndB(gyu, gyo);     % Wert von M2
    M1 = triangrnd(1, gzu, gzo); % Wert von M1
    
                                 % neuen Schliemawert berechnen
    A = [A, atan( (M2+M2)/M1 )];
end;

% Werte aufsteigend sortieren

A = sort(A);

% Berechnung des Ergebnisses und Darstellung in Form eines Histogramms

                         % grter Wert zur Festlegung des Darstellungsbereichs
mBereicho = max(A);
                         % kleinster Wert zur Festlegung des Darstellungsbereichs
mBereichu = min(A);
                         % Bestimmung der Klassenanzahl und der Klassenmitten
KlAnz = max(5, floor(sqrt(M)));
KlAnz = min(KlAnz, 50);
dx = (mBereicho-mBereichu)/KlAnz;
bins = (mBereichu+dx/2:dx:mBereichu+KlAnz*dx-dx/2);

                         % Berechnung der Histogrammbalken
[N, bins, density, vFnkt] = distempStetig(A, bins, 0);

                         % Plot des Histogramms

bar(bins, density, 0.8);

xlabel('Werte von A');
ylabel('Nherung der Verteilungsdichte');

    


