function [ZahlPi] = MCPi(N)
%
% Funktion MCPi
%
% Aufruf:  [ZahlPi] = MCPi(N)
%
% Aufrufbeispiel:    [ZahlPi] = MCPi(100000)
%
% Die vorliegende Funktion berechnet, die Zahl pi mit Hilfe der
% MONTE-CARLO-METHODE !!
%
% Das Programm schtzt den FLCHENINHALT des Einheitskreises, indem die Treffer
% innerhalb des Kreises und die im umschlieenden Quadrat ins Verhltnis gesetzt werden.
%
%
% Eingabeparameter: 		    N           Anzahl(>0) der Zufallspunkte fr die MONTE-CARLO-Berechnung
%
% Ausgabeparameter: 		    ZahlPi      Schtzung der Zahl pi
%                                       
						
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 5.03.2003


% Vorinitialisierungen

Treffer = 0;

rand('state',sum(100*clock));    % Zufallsgenerator initialisieren

for k=1:N                        % Zahl der Iterationen 
                                 % N Zufallspunkt im Rechteck [-1,1]x[-1,1] bestimmen
    X = [2*rand(1,1)-1, 2*rand(1,1)-1];
                                 % Prfen, ob Punkt im Einheitskreis liegt
    if norm(X)<=1
        Treffer = Treffer +1;    % falls ja, Trefferzahl erhhen
    end;
end;

% Flche berechnen (gleichzeitig Schtzung fr Zahl pi)
% 4 ist die Flche des Rechtecks

ZahlPi = 4*Treffer/N;

