function [ZahlPiG] = MCPiGauss(N)
%
% Funktion MCPi
%
% Aufruf:  [ZahlPiG] = MCPiGauss(N)
%
% Aufrufbeispiel:    [ZahlPiG] = MCPiGauss(100000)
%
% Die vorliegende Funktion berechnet, die Zahl pi mit Hilfe einer UNANGEPASSTEN (!)
% MONTE-CARLO-METHODE !!
%
% Das Programm schtzt den FLCHENINHALT des Einheitskreises, indem die Treffer
% innerhalb des Kreises und die im umschlieenden Quadrat ins Verhltnis gesetzt werden.
% Die Zufallszahlen sind dabei allerdings GAUSS-VERTEILT. Somit werden der
% Flcheninhalt und damit pi nicht korrekt geschtzt!
%
%
% Eingabeparameter: 		    N           Anzahl(>0) der Zufallspunkte fr die MONTE-CARLO-Berechnung
%
% Ausgabeparameter: 		    ZahlPi      (falsche) Schtzung der Zahl pi
%                                       						
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 5.03.2003


% Vorinitialisierungen

Treffer = 0;

rand('state',sum(100*clock));    % Zufallsgenerator initialisieren

for k=1:N                        % Zahl der Iterationen   
                                 % Zufallspunkt im Rechteck [-1,1]x[-1,1] bestimmen
                                 % normrndB(0,1/3,1,1) erzeugt Gauss-verteilte Zahl
                                 % mit Mittelwert 0 und Streuung 1/3 (3*sigma =1)!
X = [normrndB(0,1/3,1,1), normrndB(0,1/3,1,1)];
                                 % falls Zahlen >1 oder <-1, so werden Sie auf 1 bzw.
                                 % -1 gesetzt
X = (X<=1).*X + (X>1);
X = (X>=-1).*X + (X<-1)*(-1);
                                 % Prfen, ob Punkt im Einheitskreis liegt
    if norm(X)<=1
        Treffer = Treffer +1;    % falls ja, Trefferzahl erhhen
    end;
end;

% Flche berechnen (gleichzeitig Schtzung fr Zahl pi)
% 4 ist die Flche des Rechtecks

ZahlPiG = 4*Treffer/N;

