function [avals, OCval] = MCRegAF2ord(aanf, aend, n, N, MCIts, sigma, sxx)
%
% Funktion MCRegAF2ord
%
% Aufruf:  [avals, OCval] = MCRegAF2ord(aanf, aend, n, N, MCIts)
%
% Aufrufbeispiel:    [avals, OCval] = MCRegAF2ord(-5, 5, 15, 100, 10000, 1, 1)
%
% Die vorliegende Funktion berechnet den FEHLER 2.ART fr einen Test auf
% Regression auf der Grundlage der so genannten F-Statistik mit Hilfe der
% MONTE-CARLO-METHODE !!
%
%
% Eingabeparameter: 		    aanf        Parameter [aanf,aend] werden durchgerechnet
%                                           
%                               aend        Parameter [aanf,aend] werden durchgerechnet
%                                           (aend muss grer als aanf sein!)
%
%                               n           Zahl der Freiheitsgrade
%
%                               N           Zahl der Sttzstellen im Intervall [0,aend]
%
%                               MCIts       Anzahl(>0) der Zufallspunkte fr die MONTE-CARLO-Berechnung
%                                           (pro Parameter a, dh. insgesamt werden N*MIts Punkte
%                                            berechnet)
%
%                               sigma       Streuung der unsystematischen Strung im Regressionsmodell
%
%                               sxx         Variation der unabhngigen Werte des Modells
%
% Ausgabeparameter: 		    avals       Sttzstellen in [0, aend]
%                                       
%                               OCVal       Berechneter Fehler 2. Art
%								
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 3.11
% Datum: 22.01.2004


% Sttzstellen fr die durchlaufenen a-Werte berechnen

da = (aend-aanf)/N;
avals = (aanf:da:aanf+(N-2)*da); 
avals = [avals, aend];


% Kritischen Wert fr den F-Test bestimmen (immer alpha = 5%)

u_krit = finvB(0.95, 1, n-2);


% Annahmewahrscheinlichkeit fr Nullhypothese H0 fr
% jeden Wert aus [aanf, aend] mit Hilfe einer Monte-Carlo-Simulation bestimmen

for k=1:N                        % alle Punkte durchlaufen
                                 % normalverteilte Zhler
    nvvals =  normrndB(avals(k)*sqrt(sxx)/sigma, 1, 1, MCIts); 
                                 % Chi-Quadrat verteilte Nenner
    ch2vals = chi2rndB(n-2, 1, MCIts); 
                                 % Werte der F-Statistik
        F = (nvvals.^2)./(ch2vals/(n-2));  
     
    absh = sum(F<=u_krit);       % Absolute Hufigkeit, dass F < kritischer Wert
    OCval(k) = absh/MCIts;       % Schtzung fr Fehler 2. Art
    
end;