function [T, Pars] = MCWeibMixTestStatT1T2(T1_0, T2_0, N, M)
%
% Funktion MCWeibMixTestStatT1T2
%
% Aufruf: [T, Pars] = MCWeibMixTestStatT1T2(T1_0, T2_0, N, M)
%
% Funktion, die M Stichproben der Lnge N  einer Zufallsvariablen erzeugt, 
% deren Verteilung Mischverteilung einer berlagerung von ZWEI Weibull-verteilten 
% Zufallsvariablen nach dem
%
% Modell:  Y = B*X1 + (1-B)*X2
%
% ist.
%
% Dabei sind X1, X2 mit den Parametern b1, T1 und b2, T2 Weibull-verteilt sind
% und B eine Bernoulli-verteilte Zufallsgre ist mit (Anteils-)Wahrschein-
% lichkeit p.
%
% Die Werte p, b1 und b2 sind auf 1/4, 3/4 und 5 fixiert.
%
% Aus den Stichproben werden nach der Methode der Kleinsten Quadrate
% mit Hilfe der Funktion nlinfit Werte fr die Verteilungsparameter
% geschtzt, aus denen der Wert T der Testvariablen
%
%         T = T1 - T2
%
% berechnet wird.
%
% Eingabeparameter:    T1_0, T2_0  Parameter der Nullhypothese
%
%                      N           Lnge der Stichprobe
%
%                      M           Zahl der Stichproben
%
% Ausgabeparameter:    T           Werte der Testvariablen T
%
%                      Pars        Mx5-Matrix der gefundenen Schtzungen
%                                  (zu Testzwecken)
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 29.01.2004

% Zuordnung der Parameter

p_0 = 1/4;  b1_0 = 3/4; b2_0 = 5;

% M Stichproben der Lnge N  entsprechend Nullhypothesenparametern
% mit Zufallsgenerator erzeugen

Zwerte = WeibullCombrnd([b1_0, T1_0, b2_0, T2_0], p_0, N, M)';

% Berechnung der Statistik T fr jede Stichprobe (Zeile)

T = []; Pars = [];

for k=1:M
    % Schtzung der Parameter fr diese Stichprobe
    [T1, T2] = FTWeibullCombT1T2(Zwerte(k,:), T1_0, T2_0);
  
    params = [p_0, b1_0, T1, b2_0, T2];
    Pars = [Pars; params];
    
    % Berechnung und Speicherung der Teststatistik T
    
    Taktuell = T1 - T2;
    T = [T, Taktuell];
end;

