function [vals] = Mu2Modalfun(mu2, x, klmitten)
%
% Aufruf:  [vals] = Mu2Modalfun(beta, x, klmitten)
%
% Beispielaufruf: [vals] = Mu2Modalfun(9.0, 8.0, (7.5:0.1:11.5)')
%
% Funktion zur Berechnung der theoretischen Klassenhufigkeiten
% einer Mischverteilung zweier Normalverteilungen mit den Parametern 
% lambda, mu_1, , sigma_1, mu_2, sigma_2 fr die Klassenmitten aus klmitten.
% Dabei sind alle Parameter bis auf mu_2 wie folgt fest vorgegeben.
% Diese Parameter mssen der Funktion ber eine GLOBALE VARIABLE
% beta0 zur Verfgung gestellt werden.
%
% Beispiel:   global beta0
%
%             beta0 = [1/3, 8.5, 1/3, 9, 1/3];
%
%
% Eingangsdaten:	  klmitten   gewhlte Klassenmitten
%                     x          eine der Klassenmitten
%                     mu2        Parameter mu_2
%
% Ausgangsdaten:	  vals       theoretische Klassenhufigkeiten
%                                der Mischverteilung
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 6.1.2004/14.9.2004

% Global-Deklaration fr beta0

global beta0

% Parameter der Mischverteilung

lambda = beta0(1); mu_1 = beta0(2); sigma_1 = beta0(3); sigma_2 = beta0(5);
mu_2 = mu2;

% Klassengrenzen aus den Klassenmitten berechnen

dxs = diff(klmitten)/2;
klsgrnz = klmitten(1:end-1)+dxs;
klsgrnz = klsgrnz(:);       % Spaltenvektor
klsgrnz = [-Inf; klsgrnz; Inf];

indx = find(x==klmitten);
grz = [klsgrnz(indx), klsgrnz(indx+1)];
% Theoretische Klassenhufigkeit berechnen

vals = lambda*(normcdfB(grz(2), mu_1, sigma_1)-...
             normcdf(grz(1), mu_1, sigma_1))...
       + (1-lambda)*(normcdfB(grz(2), mu_2, sigma_2)-...
                   normcdf(grz(1), mu_2, sigma_2));
