function [d] = NLdist(beta, h)
%
% Funktion NLdist.m
%
% Aufruf:  [d] = NLdist(beta, h)
%
% Beispiel zur NICHTLINEAREN Regression.
% Diese Funktion definiert die Vorschrift eines NICHTLINEAREN Modells
% fr ein auf Galileo zurckgehendes Fallexperiment.
% Die Funktion berechnet die Distanz d, die eine Kugel im freien Fall
% nach dem Verlassen einer Rampe zurcklegt, nachdem sie die Rampe ab
% einer Hhe h herabgerollt ist.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 18.11.2003

% Modellparameter

b1 = beta(1); b2 = beta(2);

% Modell der nichtlinearen Regressionsfunktion

d = (1/(2*b1))*(h*b2 + sqrt(h.^2*b2^2+4*b1*h));

