function [y] = NsProb(x, f, p)
%
% Funktion NsProb
%
% Aufruf:  [y] = NsProb(x, f, p)
%
% Aufrufbeispiel:    [y] = NsProb((-1:0.01:3), @FBspVertFkt, 0.3)
%
% Mit Hilfe der vorliegenden Funktion kann das Problem
% f(x) = p in das Nullstellenproblem f(x)-p=0 umgewandelt 
% werden (damit die Gleichung fzero gelst werden kann).
%
%
% Eingabeparameter: 		    f           handle auf eine reelle Funktion
%
%                               x           reeller Vektor
%
%                               p           reelle Zahl
%
%
% Ausgabeparameter: 		    y           Wert der Verteilungsfunktion zu x
%                                       
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.03.2003


y = feval(f,x)-p;