function [mu, OC] = OCztest(mu0, sigma, Delta, n, alpha)
%
% Funktion OCztest
%
% Aufrufbeispiel: [mu, OC] = OCztest(100, 0.5, 2, 10, 0.05)
%
% Berechnet die Operationscharakteristik fr einen zweiseitigen Mittelwerttest einer 
% Normalverteilung bei bekannter Varianz sigma in einem Intervall +-Delta um den
% Mittelwert mu0 der Nullhypothese (H0) herum.
%
% Die Stichprobenlnge ist dabei n und das Signifikanzniveau alpha.
%
%
% Eingabeparameter:    mu0     Mittelwert entsprechend Nullhypothese
%                      sigma   bekannte Standardabweichung der Normalverteilung
%                      Delta   Symmetrische Grenze fr die Darstellung der OC
%                      n       Stichprobenlnge des Tests 
%                      alpha   Signifikanzniveau des zweiseitigen z-Tests
%
% Ausgabeparameter:    mu      Sttzstellen im Intervall [mu0-Delta, mu0+Delta]
%                              fr die Darstellung des OC
%                      OC      Werte der Operationscharakteristik
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 29.10.2002

% (2-alpha)/2-Quantil der Standard-Normalverteilung berechnen

u_gamma = norminvB((2-alpha)/2, 0, 1);

% Kritischen Wert c berechnen

c = u_gamma*sigma/sqrt(n);  

% Auswertestellen fr die OC im Intervall [mu0-Delta, mu0+Delta] berechnen.
% Es sollen in dieser Version immer 1000 Sttzstellen genommen werden.

dmu = 2*Delta/1000;
mu = (mu0-Delta:dmu:mu0+Delta);
   
% Berechnung der OC fr diese Werte. Dies ist die Wahrscheinlichkeit
% fr Xquer im Intervall [mu0-c,mu0+c] zu liegen, wenn mu der
% tatschliche Erwartungswert ist!

OC = normcdfB(mu0+c,mu,sigma/sqrt(n))-normcdfB(mu0-c,mu,sigma/sqrt(n));

% Plot der Operationscharakteristik

text = 'Erwartungswerte';    
plot(mu, OC, 'r-', 'LineWidth', 3);
set(gca, 'FontSize', 12);
xlabel(text);
ylabel('OC')


