% Script-File RegressVInt.m
%
% Aufruf:  RegressVInt
%
% Beispiel zur Berechnung der Vertrauensintervalle fr Regressionskoeffizienten
% und Regressionskonstante. Es werden die Regressionsparameter fr  die
% Fahrzeugbreite-Wendekreisradius-Beziehung des Datensatzes CarDATA93cars.dat
% verwendet!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 14.10.2003


% Laden des Datensatzes CarDATA93cars.dat

ReadCarData

% Zahl der Datenpunkte

n = length(Breite);

% "Fehler"quadratsumme der Einflusgre "Breite"
% (var berechnet empirische Varianz; siehe Definition)

ssx = (n-1)*var(Breite);

% Berechnung des arithmetischen Mittels der Einflussgren

xquer = mean(Breite);

% Berechnung der Regressionsparameter

X = [Breite, ones(length(Breite),1)];
beta = regressB(Wendekreis,X);

a = beta(1); b = beta(2);

% Berechnung der Residuenquadratsumme

ssr = sum( (Wendekreis - a*Breite - b).^2 );

% Berechnung des zweiseitigen alpha-Quantils der t-Verteilung
% mit (n-2) Freiheitsgeraden

alpha = 0.05;                    % Signifikanzniveau 5%
utilde = tinvB(1-alpha/2, n-2);

% Berechnung des Vertrauensintervalls fr den 
% Regressionskoeffizienten a

cua = a - utilde*sqrt(ssr/((n-2)*ssx));
coa = a + utilde*sqrt(ssr/((n-2)*ssx));

% Berechnung des Vertrauensintervalls fr die
% Regressionskonstante b

cub = b - utilde*sqrt(ssr*(1/n+xquer^2/ssx)/(n-2));
cob = b + utilde*sqrt(ssr*(1/n+xquer^2/ssx)/(n-2));

% Ausgabe des Ergebnisses

fprintf('\nVertrauensintervall fr den Regressionskoeffizienten a:\n');
fprintf('[%7.4f,  %7.4f]\n\n', cua, coa);
fprintf('\nVertrauensintervall fr die Regressionskonstante b:\n');
fprintf('[%7.4f,  %7.4f]\n\n', cub, cob);