function [ElEreignis] = UrnenExp2Ziehung(n, k)
%
% Funktion [ElEreignis] = UrnenExp2Ziehung(n, k)
%
% Beispielaufruf:  [ElEreignis] = UrnenExp2Ziehung(5, 3)
%
% Illustration zum Urnenexperiment "Ziehen MIT ZUrcklegen und OHNE
% Bercksichtigung der Reihenfolge. Die Funktion liefert mit Hilfe eines
% MATLAB-Zufallsgenerators das Ergebnis eines Experiments mit k Ziehungen.
%
% Eingabeparameter:            n            Elemente der Urne [1,2,3,..,n]
%                              k            Zahl der Ziehungen
%
% Ausgabeparameter:            ElEreignis   Elementarereignis
%
%
% Es werden keine Fehleingaben abgefangen!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2003

% Elementarereignis leer vorinitialisieren
ElEreignis = [];

for j=1:k                    % fr jede Ziehung
                             % Zufallsgenerator aufrufen und
                             % Wert hinzufgen
    ElEreignis = [ElEreignis, unidrndB(n)];
end;

% Werte zuletzt aufsteigend sortieren

ElEreignis = sort(ElEreignis);