% Script-File VWRegress.m
%
% Aufruf:  VWRegress
%
% Beispiel zur NICHTLINEAREN Regression.
% Dieses Script ermittelt die Regressionsparameter eines EXPONENTIELLEN
% Modells fr den Zusammenhang zwischen Preis und Alter eines VW Golf
% (Daten aus VWGolf.dat)
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.12.2003

% Laden der Daten aus VWGolf.dat

load VWGolf.dat
alter = VWGolf(:,1);
preis = VWGolf(:,3);

% Bestimmung eines Startvektors

%beta = [0,0,0];  % Willkrlich gewhlt!

% Bei Verwendung von nlinfitB muss ein besserer Startwert
% gewhlt werden !!!!

beta = [0,1000,0];  % besserer Startwert

% Berechnung der Modellparameter mit nlinfit

[betahat, R, J] = nlinfitB(alter,preis,@expModell,beta)

% Berechnung der Anpassungskurve und Darstellung mit den
% Daten aus VWGolf.dat

pfit = expModell(betahat, alter);

scatter(alter,preis, 45, 'r-', 'filled');
xlabel('Zeit seit Erstzulassung/Monate', 'FontSize', 12)
ylabel('Preis/Euro', 'FontSize', 12)
set(gca, 'FontSize', 12)
hold
[xsort, Indx] = sort(alter);       % Daten aufsteigend sortieren
plot(xsort, pfit(Indx), 'b-', 'LineWidth', 3);

