% Script-File VertIntvNV.m
%
% Aufruf:  VertIntvNV
%
% Beispiel zur Berechnung eines Vertrauensintervalls
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 17.09.2002

% Stichprobe Tabelle Vertrauensintervalle
probe = [100.1,101.2,99.5,99.0,100.7,100.0,101.2,99.2,99.0,98.7];

% Definition der bekannten Streuung sigma
sigma = 0.5;

% Bestimmung der Stichprobenlnge n
n = length(probe);

% Bestimmung des empirischen Mittels xquer
xquer = mean(probe);

% Bestimmung der empirischen Varianz sq und der empirischen
% Streuung s
sq = var(probe);
s = sqrt(sq);

% Bestimmung des zweiseitigen 95%-Quantils 
% (einseitigen 97.5%-Quantils) der Standardnormalverteilung
ugamma = norminvB(0.975, 0, 1);

% Untere Vertrauensintervallgrenze bei bekannter Varianz
cu = xquer - ugamma*(sigma/sqrt(n));

% Obere Vertrauensintervallgrenze bei bekannter Varianz
co = xquer + ugamma*(sigma/sqrt(n));

% Ausgabe des Ergebnisses
fprintf('\n95%%-Vertrauensintervall fr den Mittelwert bei bekannter Varianz  : [%10.4f,%10.4f]',cu,co);

% Bestimmung des zweiseitigen 95%-Quantils 
% (einseitigen 97.5%-Quantils) der t-Verteilung
% mit n-1 Freiheitsgraden
ugammatilde = tinvB(0.975, n-1);

% Untere Vertrauensintervallgrenze bei unbekannter Varianz
cutilde = xquer - ugammatilde*(s/sqrt(n));

% Obere Vertrauensintervallgrenze bei unbekannter Varianz
cotilde = xquer + ugammatilde*(s/sqrt(n));

% Ausgabe des Ergebnisses
fprintf('\n95%%-Vertrauensintervall fr den Mittelwert bei unbekannter Varianz: [%10.4f,%10.4f]',cutilde,cotilde);
    
% Bestimmung des einseitigen 5%-Quantils 
% der Chi-Quadrat-Verteilung mit n-1 Freiheitsgraden
ug2u = chi2invB(0.05, n-1);

% Bestimmung des einseitigen 95%-Quantils 
% der Chi-Quadrat-Verteilung mit n-1 Freiheitsgraden
ug2o = chi2invB(0.95, n-1);

% Untere 90%-Vertrauensintervallgrenze fr die Varianz
cuhat = (n-1)*sq/ug2o;

% Obere 90%-Vertrauensintervallgrenze fr die Varianz
cohat = (n-1)*sq/ug2u;

% Ausgabe des Ergebnisses
fprintf('\n90%%-Vertrauensintervall fr die Varianz der Normalverteilung      : [%10.4f,%10.4f]',cuhat,cohat);