function [Zwerte] = WeibullCombrnd(params, p, N, M)
%
% Funktion: WeibullCombrnd
%
% Aufruf: [Zwerte] = WeibullCombrnd(params, p, N, M)
%
% Funktion, die Zufallswerte einer berlagerung von ZWEI 
% Weibull-verteilten ZUfallsvariablen zurckliefert.
%
% Modell:  Y = B*X1 + (1-B)*X2
%
% wobei X1, X2 mit den Parametern b1, T1 und b2, T2 Weibull-verteilt sind
% und B eine Bernoulli-verteilte Zufallsgre ist mit (Anteils-)Wahrschein-
% lichkeit p.
%
% Eingabeparameter:    params  Weibull-Parameter b1, T1 und b2, T2
%
%                      p       Parameter von B; Anteil von X1 an der Mischung
%
%                      N,M     Dimension von Zwerte (z.B. N = 100, M = 1
%                              fr einen Spaltenvektor von Zufallszahlen)
%
% Ausgabeparameter:    Zwerte  Zufallswerte
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 24.01.2004

b1 = params(1);
T1 = params(2);
b2 = params(3);
T2 = params(4);

a1 = 1/(T1^b1);           % Anpassung der Parameter auf die MATLAB-Definition
a2 = 1/(T2^b2);
                          % Berechnung Mischvariablen-Werte
B = binornd(1,p,N,M);     % Bernoulli-Variable mit Parameter p (Anteil X1)                          
Zwerte = B.*weibrnd(a1, b1, N, M) + (1-B).*weibrnd(a2, b2, N, M);
