function [werte] = dWeibullComb(x, params, p)
%
% Funktion, die fr alle x die Werte der Verteilungsdichte
% einer berlagerung von ZWEI Weibull-Verteilungen
% (Weibull-Mischverteilung) zurckliefert.
%
% Modell:  f(x) = p*W(b1,T1)+(1-p)*W(b2,T2)
%
% Eingabeparameter:    x      Vektor der Abzissenwerte (reell)
%
%                      params Weibull-Parameter b1, T1 und b2, T2
%
%                      p      Wahrscheinlichkeit W(b1,T1)-verteilter Werte
%
% Ausgabeparameter:    werte  Werte der Verteilungsfunktion
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 20.12.2003

b1 = params(1);
T1 = params(2);
b2 = params(3);
T2 = params(4);

a1 = 1/(T1^b1);           % Anpassung der Parameter auf die MATLAB-Definition
a2 = 1/(T2^b2);
                          % Berechnung Misch-Verteilungsdichte
werte = p*weibpdfB(x, a1, b1) + (1-p)*weibpdfB(x, a2, b2);

