function [vals, emdist, cemdist]= distempDiskret(data, plotten)
%
% Funktion distempDiskret(data, plotten)
%
% Aufruf:  [vals, emdist, cemdist] = distempDiskret(data, plotten)
%
% Berechnet die empirische Verteilung und die empirische Verteilungsfunktion
% fr den Eingangsdatenvektor data der Werte einer DISKRETEN Zufallsvariablen
% und stellt diese auf Wunsch grafisch dar.
% 
% Eingangsdaten:	  data      Datenvektor (Stichprobe)
%			          plotten   0 falls Ergebnis nicht geplottet werden soll, 
%                                 sonst wird geplottet.
%
% Ausgangsdaten:	  vals      Wertevektor 
%			          emdist    rel. Hufigkeit
%			          cemdist   kumulative re. Hufigkeit
%
%
% Es werden KEINE Fehleingaben abgefangen !!
% 		
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 3.01
% Datum: 6.9.2003

% Eingangsdatenvektor data = (y_1,...,y_n) mit MATLAB-Funktion
% sort aufsteigend sortieren

data = data(:)';
sortdata = sort(data);

% Erkennen, ob Werte mehrfach vorkommen
% Dazu wird MATLABs diff-Funktion verwendet

diffdata = (diff(sortdata)~=0);

% Die verschiedenen Werte aus sortdata extrahieren
% Es entsteht ein aufsteigend sortierter Datenvektor x_1 bis x_m

mehrfach = logical([1,diffdata]);
vals = sortdata(mehrfach);

% Berechnung der absoluten Hufigkeiten mit Hilfe der hist-Funktion
% Die absoluten  Hufigkeiten werden dabei ber den TATSCHLICH VORKOMMENDEN
% WERTEN aufgetragen.

[anz,binpos] = hist(data, vals);

% Berechnung der relativen Hufigkeiten
emdist = anz/length(data);

% Kumulative Hufigkeiten, also empirische Verteilungsfunktion
% ermitteln

cemdist=[0, cumsum(emdist), 1];

% Plot des Ergebnisses, falls gewnscht

if plotten
    subplot(211)
    bar(binpos, emdist, 0.5);
    set(gca, 'FontSize', 12);
    xlabel('Werte von X');
    ylabel('Relative Hufigkeit');
    dx = (max(vals)-min(vals))/10;
    axis([min(vals)-dx,max(vals)+dx,0,max(emdist)]);

    subplot(212)
    stairs([min(vals)-dx, vals, max(vals)+dx], cemdist);
    axis([min(vals)-dx,max(vals)+dx,0,1]);
    set(gca, 'FontSize', 12);
    hndl = get(gca, 'Children');
    set(hndl, 'LineWidth', 4);
    set(hndl, 'Color','r');
    xlabel('Werte von X');
    ylabel('kumul. rel. Hufigkeit');
end;