% Script-File empVerteilung
%
% Aufruf:  empVerteilung
%
% Beispiel fr die empirische Verteilung einer Stichprobe
% (s. 3.2.1)
% 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 22.8.2002

reissFest = [44.2 , 43.4 , 41.0 , 41.1 , 43.8 , 44.2 , 43.2 , 44.3 , 42.0 , 45.0,...
             43.1 , 42.9 , 43.9 , 44.8 , 46.0 , 42.1 , 45.1 , 40.9 , 43.7 , 44.0,...
             43.0 , 43.6 , 46.1 , 41.0 , 43.3 , 45.3 , 44.9 , 42.0 , 44.0 , 44.3];

sortiert =  sort(reissFest);
ndoppelt= logical([1,diff(sortiert)]);    
bins = sortiert(ndoppelt);
[anz,binposition] = hist(reissFest, bins);
N = length(reissFest);

                          % grafische Darstellung
h = bar(bins, anz/N, 0.5);
set(gca, 'FontSize', 12);
xlabel('Zugfestigkeit/kg/mm^2');
ylabel('Relative Hufigkeit');
axis([min(reissFest)-1,max(reissFest)+1,0,max(anz/N)]);


