function [werte] = fWeibull(params,x)
%
% Funktion, die fr alle x die Werte der Weibull-Verteilungsfunktion
% zurckliefert.
%
% Eingabeparameter:    x      Vektor der Abzissenwerte (reell)
%
%                      b,T    Weibull-Parameter
%
% Ausgabeparameter:    werte  Werte der Verteilungsfunktion
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
% siehe auch: dWeibull
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 19.9.2002

b = params(1);
T = params(2);

a = 1/(T^b);              % Anpassung der Parameter auf die MATLAB-Definition
                          % Berechnung Weibull-Verteilungsdichte
werte = weibcdfB(x, a, b);

