function [ExpZahlen] = getExpVar(lambda, N)
%
% Funktion getExpVar
%
% Aufruf:  [ExpZahlen] = getExpVar(lambda, N)
%
% Aufrufbeispiel:    [ExpZahlen] = getExpVar(1/2, 100)
%
% Mit dieser Funktion knnen N exponentiell verteilte Zufallszahlen erzeugt werden.
% Die Erzeugung erfolgt dabei mit Hilfe des Zufallsgenerators fr GLEICHVERTEILTE
% Zufallszahlen und eine geeignete Transformationsformel.
%
%
% Eingabeparameter: 		    N           Anzahl(>0) der Zufallspunkte 
%
%                               lambda      Parameter der Exponentialverteilung 
%                                          (F_Y(y) = 1-exp(-lambda*y))
%
% Ausgabeparameter: 		    ExpZahlen   Erzeugte Zufallszahlen
%                                      					
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 5.03.2003


% Vorinitialisierungen

ExpZahlen = [];

rand('state',sum(100*clock));    % Zufallsgenerator initialisieren

for k=1:N                        % Zahl der Iterationen 
                                 % (Gleichverteilten) Zufallspunkt im Intervall 
                                 % [0,1] bestimmen
    x = rand(1,1);
                                 % Transformationsformel anwenden
    y = -(1/lambda)*log(1-x);
                                 % Wert speichern
    ExpZahlen = [ExpZahlen; y];  
end;
