function [relH] = ggzexp(n)
%
% Funktion ggzexp
%
% Aufruf:  [relH] = ggzexp(n)
%
%
% Diese Funktion erzeugt standard-normalverteilte Zufallszahlen und
% bestimmt die relative Hufigkeit x/n fr die Anzahl x des Auftretens
% des Ereignisses, dass die Zufallszahl <-1 ist.
%
% Beispiel zum Thema Stabilisierung der Hufigkeiten; Gesetz der
% groen Zahlen.
% 
%
% Eingabeparameter:    n         Anzahl der erzeugten Zufallszahlen (Experimente)
%
% Ausgabeparameter:    relH      berechnete relative Hufigkeit
%
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 3.9.2002


randn('state',sum(100*clock));   % Zufallsgenerator neu initialisieren

y = randn(1,n);                  % n Zufallszahlen erzeugen

less = y < -1;                   % Bestimmen, welche < -1 sind

x = sum(less);                   % Anzahl dieser Zahlen bestimmen

relH = x/n;                      % relative Hufigkeit zurckliefern


