function [verteilung] = sumBernoulli(p, n)
%
% Verteilung der Summe n unabhngiger Bernoulli-verteilter
% Zufallsvariablen und Plot als Balkendiagramm
%
% Eingabeparameter:    p           Parameter der Bernoulli-Verteilung
%
%                      n           Zahl der unabhngigen Variablen
%
% Ausgabeparameter:    verteilung  Verteilung der Summenvariablen Z
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.02
% Datum: 14.8.2004

% Bernoulli-Verteilung

vrtBernoulli = [1-p, p];

% Schleife zur Erzeugung der Summenverteilung

verteilung = vrtBernoulli;
for k=2:n
    verteilung = conv(vrtBernoulli, verteilung);
end;

% Plot der Summenverteilung

bar((0:1:length(verteilung)-1), verteilung);
axis([-1, length(verteilung), 0, 1.1*max(verteilung)]);
set(gca, 'FontSize', 12);
xlabel('z')
ylabel('f_Z(z)')

