function [verteilung] = sumExp(lambda, n)
%
% Verteilung der Summe n unabhngiger identisch mit Parameter
% lambda exponentialverteilter Zufallsvariablen
%
% Eingabeparameter:    lambda      Parameter der Exponential-Verteilung
%
%                      n           Zahl der unabhngigen Variablen
%
% Ausgabeparameter:    verteilung  Verteilung der Summenvariablen
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.02
% Datum: 14.8.2004

% Feststellung der wesentlichen Werte der Exponentialverteilung
% Dazu wird das 99.999%-Quantil verwendet (99.999% aller Werte
% der Zufallsvariablen liegen dann im Intervall [0, u_p]

p = 0.99999;
u_p = expinvB(p, 1/lambda);

% Berechnung der Werte der Verteilung im Intervall [0, u_p]
% (Es werden immer 1001 Sttzstellenwerte bestimmt)

dt = u_p/1000;
pts = (0:dt:u_p);
ExpV = exppdfB(pts, 1/lambda);

% Schleife zur Erzeugung der Summenverteilung
% Beachte: dt des Integrals muss bercksichtigt werden!
% (Integral wird durch Faltungssumme * dt approximiert)

verteilung = ExpV;
for k=2:n
    verteilung = conv(ExpV, verteilung)*dt;
end;

% Plot der Summenverteilung

werte = (0:dt:n*u_p);               % Wertebereich der Summen-
                                    % verteilung ist n*u_p
plot(werte, verteilung, 'LineWidth', 4);
set(gca, 'FontSize', 12);
axis([0, n*u_p, 0, max(verteilung)]);
xlabel('x')
ylabel('f(x)')

