function [verteilung] = sumGeoV(p,n)
%
% Berechnung der Verteilung der Summe n unabhngiger 
% geometrisch verteilter Zufallsvariablen mit Hilfe der
% numerischen Faltung.
%
% Eingabeparameter:    p           Parameter der geometrischen Verteilung
%
%                      n           Zahl der unabhngigen Variablen
%
% Ausgabeparameter:    verteilung  Verteilung der Summenvariablen
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.9.2002

% Geometrische Verteilung
grenze = geoinvB(0.999999, p); % Approximation des Wertebereiches bis zum
                               % 99,9999%-Quantil
x = (0:1:grenze);
GeoV = geopdfB(x,p);           % Werte der Verteilung

% Schleife zur Erzeugung der Summenverteilung
verteilung = GeoV;
for k=2:n
    verteilung = conv(GeoV, verteilung);
end;






