% Script-File testmom.m
%
% Aufruf:  testmom
%
% Beispiel Kennwertberechnung mit der Momentmethode
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 13.12.2002

mu = 2; sigma = 1;

x = normrndB(mu, sigma, 1, 10000);

% Vektor der Indexwerte k

k = (1:1:10000);

% Bestimmung der empirischen Momente

xquer = mean(x);
m2 = sum(x.^2)/length(x);

% Schtzung der Parameter mu und sigma^2 mit solve
% (im vorliegenden Fall eigentlich nicht ntig, da
% die Lsung trivial ist)

S = solve( 'm = xq', 's = mom2 - m^2', 'm,s');


fprintf('\n%s:   %10.4f', 'Originalparameter EW      ', mu);
fprintf('\n%s:   %10.4f', 'Moment-Schtzung EW       ', subs(S.m, xquer));
fprintf('\n%s:   %10.4f', 'Originalparameter Varianz ', sigma^2);
fprintf('\n%s:   %10.4f', 'Moment-Schtzung Varianz  ', subs(subs(S.s,'xq',xquer),'mom2',m2));
fprintf('\n%s:   %10.4f', 'empirische Varianz mit var', var(x));