function [vdichte] = trapzpdf(x,R,gamma)
%
% Aufruf: [vdichte] = trapzpdf(x,R,gamma)
%
% Berechnung der Verteilungsdichte der Trapezverteilung 
% mit Parameter gamma im Intervall [0,R].
%
% Eingabeparameter:    x           Vektor von Werten, fr die die
%                                  Dichte berechnet werden soll
%
%                      R           rechte Intervallgrenze
%
%                      gamma       Steigungsparameter
%
% Ausgabeparameter:    vdichte     Werte der Verteilungsdichte 
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 21.3.2002


vdichte =  0*(x<0) +...
           (4*x/((1-gamma^2)*R^2)).*(x>=0 & x<(1-gamma)/2*R)+...
           (2/((1+gamma)*R)).*(x>=(1-gamma)/2*R & x<(1+gamma)/2*R)+...
           (2/((1+gamma)*R) - 4/((1-gamma^2)*R^2)*(x-(1+gamma)/2*R) )...
           .*(x>=(1+gamma)/2*R & x<R)+...
           0*(x>R);

