function [ZZahlen] = triangrnd(N, a, b)
%
% Funktion gtriangrnd
%
% Aufruf:  [ZZahlen] = triangrnd(N, a, b)
%
% Aufrufbeispiel:    [ZZahlen] = triangrnd(200, 0, 2)
%
% Mit dieser Funktion knnen N Zufallszahlen erzeugt werden, die nach
% der DREIECKSVERTEILUNG im Intervall [a,b]verteilt sind.
%
%
% Eingabeparameter: 		    N           Anzahl(>0) der Zufallspunkte 
%
%                               a,b         Intervallgrenzen fr die 
%                                           Dreiecksverteilung
%
% Ausgabeparameter: 		    ZZahlen     Erzeugte Zufallszahlen
%                                      					
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% siehe auch: Aufruf_triangVar
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 21.03.2003


% Vorinitialisierungen

ZZahlen = [];

rand('state',sum(100*clock));    % Zufallsgenerator initialisieren

for k=1:N                        % Zahl der Iterationen 
                                 % (Gleichverteilten) Zufallspunkt im Intervall 
                                 % [0,1] bestimmen
    x = rand(1,1);
                                 % Transformationsformel anwenden
    if x<=1/2
        y = (b-a)*sqrt(x/2) + a;
    else
        y = b - (b-a)*sqrt((1-x)/2);
    end;
                                 % Wert speichern
    ZZahlen = [ZZahlen; y];  
end;