% Script-File ueb1Regress1.m
%
% Aufruf:  ueb1Regress1
%
% Beispiel zur LINEAREN REGRESSION an Hand des Datensatzes CarDATA93cars.dat. 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 27.11.2003

% Laden des Datensatzes CarDATA93cars.dat

ReadCarData

% Darstellung des Datensatzes in einem Scatter-Plot

scatter(Laenge, Radstand, 30, 'r-', 'filled');
xlabel('Fahrzeuglnge/inch')
ylabel('Radstand/inch')
grf = gcf;                % Handle auf Grafik
hold


% Zahl der Datenpunkte

n = length(Laenge);

% Berechnung der Regressionsparameter

X = [Laenge, ones(length(Laenge),1)];
[beta, bint, r, rint, stats]   = regressB(Radstand,X);


% Grafische Darstellung der Regressionsgeraden

plot(Laenge, beta(1)*Laenge+beta(2), 'b', 'LineWidth', 3);


% Untersuchung der Residuen mit rcoplot
% ENTFLLT, da regressB nicht die residuen und deren Vertrauens-
% intervalle berechnet

% figure
% rcoplotB(r, rint);
% xlabel('Laenge')          % Beschriftung ndern
% ylabel('Residuen')
% title('')
% set(gca,'Color','w');     % Setzt Hintergrundfarbe wieder
%                           % auf wei
% n = length(r);            % Nullline wieder schwarz
% hold
% plot([0 (n+1)],[0 0],'-k');


% Eine Vergleichsrechnung mit der Funktion robustfit
% ENTFLLT, da robustfit nicht zur verfgung gestellt wird

% rbeta = robustfit(Laenge, Radstand);
% 
% % Die ermittelte Gerade dazu plotten
% 
% figure(grf)               % erster Plot wird aktuell
% plot(Laenge, rbeta(2)*Laenge+rbeta(1), 'k-', 'LineWidth', 3);