% Script-File Ueb2Anova1.m
%
% Aufruf:  Ueb2Anova1
%
% bung zur EINFACHEN Varianzanalyse mit einem unbancierten Versuchsplan.
% Das Beispiel "Einfluss von 4 Sprengstoffarten (in (mg/m^3)*10) auf die 
% gemessene Staubkonzentrationent entstammt dem Buch von R. Storm 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 18.6.2003


% Stichprobenwerte fr die gemessenen Staubkonzentrationen
% Die untersuchte Einflussgre ist die Sprengstoffart. 
 
% Sprengstoff 1:   
probe1 =    [ 13 9 15 5 25 15 3 9 6 12 ];

% Sprengstoff 2:   
probe2 =    [ 42 24 41 19 27  ];
%probe2 =    [ 32 24 21 19 27  ];

% Sprengstoff 3:   
probe3 =    [ 8 24 9 18 9 24 12 4 ];

% Sprengstoff 4:   
probe4 =    [ 9 12 7 18 2 18 ];


% Definition der Klassenbezeichner entsprechend der Lnge der Stichproben
% Namen fr die untersuchten Gruppen (je ein Name pro Stichprobenwert 
% der Klasse)

indx = cumsum([length(probe1), length(probe2), length(probe3), length(probe4)]);

Gr1 = repmat('Sprengstoff I', indx(1), 1); 
Gr2 = repmat('Sprengstoff II', indx(2)-indx(1), 1);   
Gr3 = repmat('Sprengstoff III', indx(3)-indx(2), 1);   
Gr4 = repmat('Sprengstoff IV', indx(4)-indx(3), 1);  
klassen = strvcat(Gr1,Gr2,Gr3,Gr4);
gruppe = cellstr(klassen);
      
% Neudefinition der Stichprobenwerte ALS VEKTOR fr die Funktion anova1     
      
probe = [probe1, probe2, probe3, probe4];      
      

% Aufruf der Funktion

[pWert, AnovTab, TestStatistik] = anova1B(probe, gruppe)