% Script-File uebungKennwerte2.m
%
% Aufruf:  uebungKennwerte2
%
% bung zur Berechnung der empirischen Kennwerte
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 17.11.2002

% Stichprobe angeben

benzin = [10.1,10.6,10.9,10.0,10.4,10.5,9.7,10.5,...
          10.4,10.1,10.8,9.2 ,10.2,10.3,10.5,9.2,...
          10.2,10.5,9.4 ,10.2,9.6 ,10.2,9.7,10.2,...
          10.8,9.9 ,10.5,10.6,9.8 ,10.7,11.2,10.8,...
          9.0 ,10.0,10.5,10.4,11.4,10.4,10.1,10.4];

% harmonischeS Mittel der Stichprobe berechnen

mh = harmmeanB(benzin);

% Zweites und drittes zentriertes Moment berechnen

mhat2 = momentB(benzin, 2);
mhat3 = momentB(benzin, 3);

% 80%- und 90%-Quantil berechnen

u_80 = prctileB(benzin, 80);
u_90 = prctileB(benzin, 90);

% Hufigkeiten berechnen

table = tabulateB(10*benzin); % Daten ganzzahlig machen!
table(:,1) = table(:,1)/10;   % Rcknormierung der Daten

% Ergebnisausgabe

fprintf('\n%s:\t %10.4f', 'harmonischer Mittelwert  ', mh);
fprintf('\n%s:\t %10.4f', '2. zentriertes Moment    ', mhat2);
fprintf('\n%s:\t %10.4f', '3. zentriertes Moment    ', mhat3);
fprintf('\n%s:\t %10.4f', '80% Quantil (Percentil)  ', u_80);
fprintf('\n%s:\t %10.4f', '90% Quantil (Percentil)  ', u_90);
fprintf('\n%s\n:',          'Hufigkeiten:  ');
table



