% Skript-File weibexp.m
%
% Aufruf:   weibexp
%
% Gegenberstellung der Dichten der Exponentialverteilung
% fr lambda = 1/T = 2 und einer Weibull-Verteilung fr Verschleiausflle
% mit den Parametern b=2 und T=1/2.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 14.08.2004

x = (0:0.01:5);
T = 2;
b = 1;                     % Exponentialverteilung
pdfexp = exppdfB(x, T);    % lambda = 1/T
b = 2;
a = 1/(T^b);               % Weibulll-Verteilung
pdfwb = weibpdfB(x, a, b);   
                           % Plotten der Dichten
plot(x,pdfexp,'r-',x,pdfwb,'b-','LineWidth',3);
set(gca, 'FontSize', 12);
xlabel('Lebensdauer', 'FontSize', 12);
ylabel('Wert der Dichte', 'FontSize', 12);
text(x(15)+0.1,pdfexp(15),'Exp-Verteilung','FontSize', 12);
text(x(200)+0.1,pdfwb(200),'Weibull-Verteilung','FontSize', 12);

figure
cdfexp = expcdfB(x,T);
cdfwb = weibcdfB(x,a,b);
plot(x,cdfexp,'r-', x, cdfwb, 'b', 'LineWidth',3);
xlabel('Lebensdauer', 'FontSize', 12);
ylabel('Wert der Verteilungsfunktion', 'FontSize', 12);
text(x(15)+0.1,cdfexp(15)+0.5,'Exp-Verteilung','FontSize', 12);
text(x(150)+0.1,cdfwb(150)+0.51,'Weibull-Verteilung','FontSize', 12);