% Skript abb2punkt08 zur Darstellung der Grafik 2.8
%
% Aufruf:  abb2punkt08
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 26.6.2004

p=0.3;                   % Parameter p der Binomialverteilung
N=10;                    % Parameter N der Binomialverteilung
n=(-2:1:12);             % Wertebereich der Darstellung
bindist=binopdfB(n,N,p); % Berechnung der Binomialverteilung
x=(-2.0:0.01:12);        % Wertebereich der Darstellung
binvert=binocdfB(x,N,p); % Berechnung der Binomialverteilungs-
                         % Funktion; NaNs auf 0 setzen
binvert(isnan(binvert))=0;
subplot(211)             % Plotten der Funktionen
h = stem(n, bindist,'r-');
set(h, 'LineWidth', 3);
set(gca, 'FontSize', 14)
axis([-2,12,0,0.35])
ylabel('P(X=n)', 'FontSize', 14);
xlabel('n', 'FontSize', 14);
set(gca, 'XTick', (-2:2:12));
xtn = ['-2'; ' 0'; ' 2'; ' 4'; ' 6';' 8'; '10'; '12'];
set(gca, 'XTickLabel', xtn)
set(gca, 'YTick', (0:0.05:0.35));
ytn = ['   0'; '0.05'; ' 0.1'; '0.15'; ' 0.2'; '0.25'; ' 0.3'; '0.35'];
set(gca, 'YTickLabel', ytn)
%
subplot(212)
plot(x, binvert, 'r-', 'LineWidth', 3)
set(gca, 'FontSize', 14)
axis([-2,12,0,1])
ylabel('P(X\leq x)', 'FontSize', 14);
xlabel('x', 'FontSize', 14);
set(gca, 'XTick', (-2:2:12));
xtn = ['-2'; ' 0'; ' 2'; ' 4'; ' 6';' 8'; ' 0'; '12'];
set(gca, 'YTick', (0:0.2:1));
ytn = ['  0'; '0.2'; '0.4'; '0.6'; '0.8'; '  1'];
set(gca, 'YTickLabel', ytn)