% Skript abb3punkt02 zur Darstellung der Grafik 3.2
%
% Aufruf:  abb3punkt02
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.02
% Datum: 23.8.2004


% vergleiche Skript-File Aufruf_MCFlaeche

% Punkte definieren (im Uhrzeigersinn!)

polygon = [
    0.2    0.2;
    0.3    0.6;
    0.6    0.6;
    0.7    0.4;
    0.5    0.2;
    0.2    0.2;];

axis([0 1 0 1])
hold on

                           % Polygon mit Farbe fllen
patch(polygon(:,1), polygon(:,2), [1,1,0.6]);
                           % Rnder nachzeichnen
for k=1:length(polygon)-1
    hndl = line([polygon(k,1),polygon(k+1,1)],[polygon(k,2), polygon(k+1,2)]);
    set(hndl, 'Color', 'r', 'LineWidth', 3);
end;


set(gca, 'FontSize', 14)
text(0.4, 0.4, 'F', 'FontSize', 14)



% Vorinitialisierungen  (hier editieren)

N = 2000;                % MC-Parameter


% Modul fr die Flchenberechnung aufrufen

[F, MCPoints] = MCFlaeche(1,1,polygon,N);

% MC-Punkte zeichnen

hold on

for j=1:length(MCPoints)
   if MCPoints(j,3)
       plot(MCPoints(j,1),MCPoints(j,2),'ro');
   else
       plot(MCPoints(j,1),MCPoints(j,2),'go');
   end;
end;


title('Flchenschtzung mit MONTE-CARLO-Methode');
text(a/2,b/2, ['Flche:  ', num2str(F)], 'FontSize', 12, 'FontWeight', 'bold');

hold off
    
% Hinweis fr den Benutzer ausgeben

fprintf('\n\nBitte beachten Sie: die zu Grunde liegenden Daten werden von einem\n');
fprintf('Zufallsgenerator erzeugt! Die Abbildung verndert sich somit bei jedem\n');
fprintf('Aufruf! Insbesondere kann Abbildung 3.2 nicht exakt reproduziert werden!\n\n');

