% Script-File abb5punkt07 zur Darstellung der Grafik 5.7
%
% Aufruf: abb5punkt07
%
% Beispiel fr die Gegenlufigkeit von Niveau und Macht;
% Erzeugt eine Grafik in 3.4.1
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 15.9.2002/1.7.2004

sigma = 0.5;
mu0 = 100;         % Nullhypothese
mu1 = 100.5;       % eine Alternative, fr die die Macht berechnet wird
n = 10;            % Stichprobenlnge

                   % Vektor der Signifikanzniveaus
alpha = (0.001:0.001:0.2);
                   % Kritischer Wert
c = norminvB((2-alpha)/2, mu0,sigma/sqrt(10))-mu0;     
                   % Berechnung der Macht fr mu1
Macht = 1- (normcdfB(mu0+c,mu1,sigma/sqrt(10))-normcdfB(mu0-c,mu1,sigma/sqrt(10)));
                   % Beschriftungstext
xltext = 'Signifikanzniveau \alpha';    
                   % Plot der Graphen                
plot(alpha, 1-alpha, 'b-', alpha, Macht, 'r-', 'LineWidth', 4);
set(gca, 'FontSize', 14);
xlabel(xltext,  'FontSize', 14);
ylabel('1-\alpha und \beta(\mu) fr \mu=100.5',  'FontSize', 14)

set(gca, 'FontSize', 14)

strg1 = cellstr(['Annahmewahrscheinlichkeit   '; 
                 'fr H0, falls Mittelwert 100']);
strg2 = cellstr(['Ablehnungswahrscheinlichkeit  '; 
                 'fr H0, falls Mittelwert 100.5']);
    
text(0.12,0.775, strg1, 'FontSize', 14);
text(0.01,0.6, strg2, 'FontSize', 14);

