% Skript abb5punkt23 zur Darstellung der Grafik 5.23
%
% Aufruf:  abb5punkt23
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 23.8.2004


% vergleiche das Skript-Files BspLogit.m

% Laden der Daten aus Kauf.dat

load Kauf.dat
x = Kauf(:,1); y = Kauf(:,2);

% Aufruf der Funktion glmfit zur Berechnung des Logit-Modells

beta = glmfit(x,[y, ones(size(y))], 'binomial','logit',[],[],[],'on');

% Berechnung der Anpassungskurve und Darstellung mit den
% Daten aus Kauf.dat

yfit = glmval(beta,x,'logit');

scatter(x, y, 30, 'r-', 'filled');
xlabel('Jahreseinkommen/Euro', 'FontSize', 14)
ylabel('Kaufentscheidung/ja=1,nein=0', 'FontSize', 14)
set(gca, 'FontSize', 14)

hold
[xsort, Indx] = sort(x);       % Daten aufsteigend sortieren
plot(xsort, yfit(Indx), 'b-', 'LineWidth', 3);

strg1 = cellstr(['Kaufwahrscheinlichkeit']);    
text(5*10^4,0.5, strg1, 'FontSize', 14);
hold 
