% Skript abb6punkt04 zur Darstellung der Grafik 6.4
%
% Aufruf:  abb6punkt04
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 3.7.2004


% vergleiche Script-File Bspbootstrp.m


% Laden der Daten

load verbrauch.dat
dx = 0.1;
klmitten = (7.5:dx:11.5);    % Klassenmitten und Breiten dx def.

% Vorinitialisierung der empirischen Modalwerte
ModW = []; 

% Zahl der Experimente und Ziehungen definieren

M = 200;
N = length(verbrauch);     % Immer alle Elemente der Grundgesamtheit

% Initialisierung des Zufallsgenerators

rand('state',sum(100*clock));    

% M Ziehungen durchfhren und Modalwert berechnen

for k=1:M
    % Ziehung von N Elementen
    indx = unidrndB(N,1,N);
    stprob = verbrauch(indx);
    
    % Modalwert berechnen und hinzufgen
    ModW = [ModW, EmpModal(stprob, klmitten)]; 
end;

% Zweiseitige alpha-Quantile der Modalwerte berechnen

alpha = 0.05;

Gu = prctileB(ModW,100*alpha/2);
Go = prctileB(ModW,100*(1-alpha/2));

[N, X, emdist, cemdist] = distempStetig(ModW, klmitten, 0);
bar(X,emdist)
axis([9.5,10.4,0,6])
xlabel('Modalwerte', 'FontSize', 14);
ylabel('rel. Klassenhufigkeit/dx', 'FontSize', 14);

hC = get(gca,'Children');
set(hC, 'FaceColor', [0.50,0.50,0.50])

set(gca, 'XTick', (9.5:0.1:10.4));
xtn = [' 9.5'; ' 9.6'; ' 9.7'; ' 9.8'; ' 9.9'; '10.0'; '10.1'; '10.2'; '10.3'; '10.4'];
set(gca, 'XTickLabel', xtn)
set(gca, 'YTick', (0:1:6));
ytn = ['0'; '1'; '2'; '3'; '4'; '5'; '6'];
% set(gca, 'YTickLabel', ytn)
set(gca, 'FontSize', 14)
