% Skript abb7punkt01 zur Darstellung der Grafik 7.1
%
% Aufruf:  abb7punkt01
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.7.2004


load ringdm.dat

% Berechnung der Mittelwerte der 5er-Proben. ringdm muss
% dafr transponiert werden, da die Mittelwerte durch mean
% ber die SPALTEN berechnet werden

xquer = mean(ringdm');

% Gesamtmittel berechnen

xqquer = mean(xquer);

% Varianzen innerhalb der Stichproben

sq = var(ringdm');

% Mittelwert der Streuungsschtzungen

stilde = mean(sqrt(sq));

% Korrekturfaktor fr Stichprobenumfang n=5 einbeziehen

s = stilde/0.94;

n = 5;
Ku = xqquer -3*s/sqrt(n);
Ko = xqquer + 3*s/sqrt(n);

% Berechnung mit xbarplot

alpha = 0.0027;
conf = 1-alpha;
Tolgrenzen = [19.985, 20.075];
verfahren = 'std';

[ausreisser, handles] = xbarplotD(ringdm, conf, Tolgrenzen, verfahren);

% Deutsche Achsenbeschriftung einfgen

xlabel('Stichproben', 'FontSize', 14)
ylabel('Messungen', 'FontSize', 14)
title('')

set(gca, 'FontSize', 14)

chlds = get(gca, 'Children');

for k=1:2
    set(chlds(k), 'LineWidth', 3);
end;
for k=3:10
    set(chlds(k), 'FontSize', 14);
end;
for k=11:length(chlds)
    set(chlds(k), 'LineWidth', 3);
end;