% Skript abb7punkt04 zur Darstellung der Grafik 7.4
%
% Aufruf:  abb7punkt04
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.7.2004


% Daten laden

load ringdm.dat

% Berechnung mit vorgegebenen Kontrollgrenzen. Diese werden
% ber den Parameter conf in der Form conf = [s, DeltaKG]
% eingestellt (s = bekannter Streuwert)

s =  0.01;
[m,n] = size(ringdm);
an = sqrt(2/(n-1))*gamma(n/2)/gamma((n-1)/2);
alpha = 0.05;   % Niveau fr so genannte Warngrenzen
ualpha = norminvB(1-alpha/2);
DeltaKG = s*ualpha*sqrt(1-an^2)/an;
conf = [s, DeltaKG];
Toleranz = [0, 0.02];

[outliers, sbar, UEG, OEG] = schartD(ringdm, conf, Toleranz);

% Deutsche Achsenbeschriftung einfgen

xlabel('Stichproben', 'FontSize', 14)
ylabel('Messungen', 'FontSize', 14)
title('')

set(gca, 'FontSize', 14)

chlds = get(gca, 'Children');

for k=3:7
    set(chlds(k), 'FontSize', 14);
end;
for k=8:length(chlds)
    set(chlds(k), 'LineWidth', 3);
end;
for k=1:2
    set(chlds(k), 'LineWidth', 3);
end;