% Skript abb7punkt06 zur Darstellung der Grafik 7.6
%
% Aufruf:  abb7punkt06
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.7.2004


load ringdm.dat

% Umwandeln der Stichprobendaten in einen Vektor und
% grafische Darstellung mit Toleranzgrenzen

daten = ringdm';
daten = daten(:);   % Daten als Spaltenvektor

% Toleranzgrenzen aus frherem Beispiel

T_u = 19.985; T_o = 20.075;
T_m = mean([T_u,T_o]);

% Daten darstellen

m = length(daten);
samples = (1:m);
hndl = plot(samples,daten, 'b-', samples,daten, 'r+',...
     samples, T_o(ones(m,1),:),'r-',...
     samples,T_m(ones(m,1),:),'g-',...
     samples,T_u(ones(m,1),:),'r-');

text(m+0.5,T_u,'T_u', 'FontSize', 14);
text(m+0.5,T_o,'T_o', 'FontSize', 14);
text(m+0.5,T_m,'T_m', 'FontSize', 14);
set(hndl,'LineWidth',3);
set(gca, 'FontSize', 14)
xlabel('Stichproben', 'FontSize', 14)
ylabel('Messungen', 'FontSize', 14)
title('')

