% Skript abb8punkt17 zur Darstellung der Grafik 8.17
%
% Aufruf:  abb8punkt17
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 23.8.2004

% vergleiche Skript-File WeibullKQS.m

% Tabelle der Ausfallhufigkeiten fr die Scheinwerfer

ausfh = [4, 7, 13, 25, 41, 50, 62, 56, 46, 37, 13, 6];

% empirische Verteilungsfunktion berechnen

N = sum(ausfh);
emph = cumsum(ausfh)/N;

% zugehrige Klassengrenzen in Tausend Kilometern

klgrenze = (30:10:140);

% Anfangsschtzungen fr die Parameter b und T

params0 = [2,50];  % b=2, T=50;

[params, R, J] = nlinfitB(klgrenze, emph, @fWeibull, params0);

% Plot von Stichprobe und Verteilungsdichte

b = params(1);
T = params(2);
a = 1/(T^b);

% Balkenhhen fr die relativen Hufigkeiten
% (Balkenflche entspricht relativer Hufigkeit!)

klassenbreite = 10;
bh = ausfh/N/klassenbreite;

% Histogramm plotten

bar(klgrenze-5, bh);
hold;

% Weibull-Dichte fr die gefundenen Parameter
% dazu plotten

intv = [klgrenze(1)-klassenbreite,klgrenze,klgrenze(end)+klassenbreite];
dichte =  weibpdfB(intv, a, b);
plot(intv, dichte,'r-','LineWidth',4);
set(gca, 'FontSize', 12);
xlabel('Ausfallzeit/ in 10^3 km');
ylabel('Wert der Verteilung/Dichte');
mx = max(max(bh),max(dichte));
axis([intv(1),intv(end),0,mx])


hC = get(gca,'Children');
set(hC(2), 'FaceColor', [0.50,0.50,0.50])

% Anpassung der Grafik

set(gca, 'FontSize', 14);
xlabel('Ausfallzeit/ in 10^3 km', 'FontSize', 14);
ylabel('Wert der Verteilung/Dichte', 'FontSize', 14);
hold