% Script-File AufgFt2test.m
%
% Aufruf: AufgFt2test
%
% bungsaufgabe zu einem F-Test und einem Zwei-Stichproben t-test fr 
% Varianz und Mittelwert der Normalverteilung
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 9.9.2003

% Datenvektoren

x = [49.13  46.66  50.25  50.57  47.70  52.38    ...
     52.37  49.92  50.65  50.34  49.62  51.45 ];

y = [49.82  55.36  50.72  51.22  53.13  51.11  51.80];

% F-Test zum Signifikanzniveau 10%

n = length(x); m = length(y);
alpha = 0.1;                      % Signifikanzniveau des F-Tests
f = var(x)/var(y);                % Wert der Testvariablen
k_o = finvB(1-alpha/2, n-1,m-1);  % oberer kritischer Wert
k_u = finvB(alpha/2, n-1,m-1);    % unterer kritischer Wert

H = ~((f>=k_u) & (f<=k_o))        % Testentscheidung
p1 = 1-fcdfB(f, n-1, m-1);
p2 = fcdfB(f, n-1, m-1);
p = 2*min(p1,p2)                  % p-Wert


% Zwei-Stichproben-t-Test zum Signifikanzniveau 5%

alpha = 0.05;                     % Signifikanzniveau des t-Tests
tail = 0;                         % Zweiseitiger Test

                                  % der t-Test mit ttest2
[H,p,KI,stats] = ttest2B(x,y,alpha,tail)
