% Skript-File Aufruf_UebungBedienSys.m
%
%
% Aufruf:  Aufruf_UebungBedienSys
%
% Lsung der bungsaufgabe zur Monte-Carlo-Simulation eines
% Bediensystems.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.02
% Datum: 14.08.2004


% Parameter setzen

vers = 3; bz = 2; T_m = 2; Tmax = 1000;

Kmax = 50;   % Simulation bis 50 Kanle
abWkt = zeros(1, Kmax);

for Knl = 1:Kmax
             % fr Knl Knale durchsimulieren
    [dabg, dang] = bedienSys(vers, Knl, bz, 1/T_m, Tmax);
    abWkt(Knl) =  100*dabg/(dabg+dang);
end;

% Darstellung des Ergebnisses

plot( (1:1:Kmax), abWkt, 'r', 'LineWidth', 4);
axis([1,Kmax,0,max(abWkt)])
xlabel('Zahl der Kanle')
ylabel('Ablehnungswahrscheinlichkeit in %');
