function [probe] = BenzVerbrauchPdf(M, beta)
%
% Diese Funktion erzeugt M Zufallswerte einer Zufallsvariablen,
% welche einer Mischverteilung aus zwei normalverteilten 
% Zufallsvariablen gengt.
%
% Verteilungsdichte f(x) = lambda*N(mu_1,sigma_1^2) + (1-lambda)*N(mu_2,sigma_2^2)
%
% Eingangsdaten:	  M          Zahl der Werte der Stichprobe
%                     beta       Parametervektor [lambda, mu_1, sigma_1, mu_2, sigma_2]
%
% Ausgangsdaten:	  probe      erzeugte Zufallswerte
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 6.1.2004

% Parameterwerte zuordnen

lambda = beta(1); mu_1 = beta(2); sigma_1 = beta(3); 
mu_2= beta(4); sigma_2= beta(5);

% Initialisierung des Zufallsgenerators

rand('state',sum(100*clock));

% Erzeuge M Werte

probe = [];
for k = 1:M
                         % zufllige Auswahl der Strassenart
                         % 1 bedeutet Stadtfahrt!
    stadtfahrt = (rand <= lambda);

    if stadtfahrt
        probe = [probe; normrndB(mu_1,sigma_1,1,1)];
    else
        probe = [probe; normrndB(mu_2,sigma_2,1,1)];
    end;
end;