% Skript-File BinPoiss.m
%
%
% Aufruf:  BinPoiss
%
% Script-File zur vergleichsweisen grafischen Darstellung der
% Binomial- und der Poisson-Verteilung (vgl. Beispiel 2.51).
%
% Die Parameter n und p mssen vor einem Lauf innerhalb des
% Skripts editiert werden.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.02
% Datum: 12.8.2004


k=(0:1:30);                      % (gff. editieren)
n=10000;  p=1/2000;              % Parameter  (hier editieren)
binvrt = binopdfB(k,n,p);        % Binomialverteilung
poivrt = poisspdfB(k,n*p);       % Poissonverteilung

subplot(211)                     % Ergebnis plotten
stem(k,binvrt,'r-');
clds = get(gca, 'Children');
set(clds(1), 'LineWidth',4);
set(clds(2), 'LineWidth',4);
set(gca, 'FontSize',14);
xlabel('k','FontSize', 14); ylabel('h_{n,p}(k)','FontSize', 14);
subplot(212)
stem(k,poivrt,'r-');
clds = get(gca, 'Children');
set(clds(1), 'LineWidth',4);
set(clds(2), 'LineWidth',4);
set(gca, 'FontSize',14);
xlabel('k','FontSize', 14); ylabel('f_P(k)','FontSize', 14);

