% Script-File BspAnova1.m
%
% Aufruf:  BspAnova1
%
% Beispiel zur EINFACHEN Varianzanalyse. Untersuchung der Signifikanz der
% Altersklasse von Autofahrern fr den durchschnittlichen Benzinverbrauch
% im Stadtverkehr.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 16.7.2003


% Stichprobenwerte fr die durchschnittlichen Benzinverbruche
% (in Litern pro 100 km). 
% Die untersuchte Einflussgre ist die Altersgruppe der Fahrer. 
% Die Benzinverbruche sind bezglich der Einflussgre
% SPALTENWEISE zu organisieren!
% 
% Untersuchtes Merkmal Altersklasse 
%         18-25 Jahre   26-40 Jahre   41-60 Jahre  ber 60 Jahre
 
  
dbv =    [    8.2          7.9            8.1           7.8; ...  % Fahrer 1
              7.8          8.3            7.5           8.1; ...  % Fahrer 2
              8.4          7.8            8.2           8.2; ...  % Fahrer 3
              8.5          8.8            8.6           8.1; ...  % Fahrer 4
              7.8          8.0            7.8           8.4; ...  % Fahrer 5
              8.8          8.0            8.3           8.1; ...  % Fahrer 6
              8.8          8.4            8.4           8.3; ...  % Fahrer 7
              8.4          8.0            7.4           7.5; ...  % Fahrer 8
              8.5          7.9            7.5           7.9; ...  % Fahrer 9
              8.4          7.7            8.2           7.8 ];   % Fahrer 10

% Durchfhrung einer Varianzanalyse mit der Funktion anova1

gruppe = cell(4,1);                   % Namen fr die untersuchten Gruppen
gruppe{1} = '18-25 Jahre'; gruppe{2} = '26-40 Jahre';
gruppe{3} = '41-60 Jahre'; gruppe{4} = 'ber 60 Jahre';

% Aufruf der Funktion

[pWert, AnovTab, TestStatistik] = anova1B(dbv, gruppe)