% Script-File BspAnova1Unbalanced.m
%
% Aufruf:  BspAnova1Unbalanced
%
% Beispiel zur EINFACHEN Varianzanalyse. Untersuchung der Signifikanz der
% Altersklasse von Autofahrern fr den durchschnittlichen Benzinverbrauch
% im Stadtverkehr.
%
% Dabei wird davon ausgegangen, dass die Zahl der Stichprobenwerte
% fr jedes Merkmal NICHT identisch ist (UNBALANCIERTER VERSUCHSPLAN).
% Zur Berechnung wird ein geeigneter Aufruf der Funktion anova1 verwendet!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 17.7.2003


% Stichprobenwerte fr die durchschnittlichen Benzinverbruche
% (in Litern pro 100 km). 
% Die untersuchte Einflussgre ist die Altersgruppe der Fahrer. 
% Die Benzinverbruche sind zunchst bezglich jeder Einflussgre
% als Spalte von Werten organisiert!
% 
% Untersuchtes Merkmal: Altersklasse 
 
% Klasse 1:   Altersklasse 18-25 Jahre
dbvK1 =    [  8.2; ...  % Fahrer 1
              7.8; ...  % Fahrer 2
              8.4; ...  % Fahrer 3
              8.5; ...  % Fahrer 4
              7.8; ...  % Fahrer 5
              8.8; ...  % Fahrer 6
              8.8; ...  % Fahrer 7
              8.4; ...  % Fahrer 8
              8.5; ...  % Fahrer 9
              8.4];     % Fahrer 10
      
% Klasse 2:   Altersklasse 26-40 Jahre      
dbvK2 =    [  7.9; ...  % Fahrer 1
              8.3; ...  % Fahrer 2
              7.8; ...  % Fahrer 3
              8.8; ...  % Fahrer 4
              8.0; ...  % Fahrer 5
              8.0; ...  % Fahrer 6
              8.4];     % Fahrer 7
      
% Klasse 3:   Altersklasse 41-60 Jahre       
dbvK3 =    [  8.1; ...  % Fahrer 1
              7.5; ...  % Fahrer 2
              8.2; ...  % Fahrer 3
              8.6; ...  % Fahrer 4
              7.8; ...  % Fahrer 5
              8.3; ...  % Fahrer 6
              8.4; ...  % Fahrer 7
              7.4; ...  % Fahrer 8
              7.5; ...  % Fahrer 9
              8.2];     % Fahrer 10
 
% Klasse 4:   Altersklasse ber 60 Jahre  
dbvK4 =    [  7.8; ...  % Fahrer 1
              8.1; ...  % Fahrer 2
              8.2; ...  % Fahrer 3
              8.1; ...  % Fahrer 4
              8.4; ...  % Fahrer 5
              7.8 ];    % Fahrer 6
      

% Definition der Klassenbezeichner entsprechend der Lnge der Stichproben
% Namen fr die untersuchten Gruppen (je ein Name pro Stichprobenwert der Klasse)

indx = cumsum([length(dbvK1), length(dbvK2), length(dbvK3), length(dbvK4)]);

Gr1 = repmat('18-25 Jahre', indx(1), 1); 
Gr2 = repmat('26-40 Jahre', indx(2)-indx(1), 1);   
Gr3 = repmat('41-60 Jahre', indx(3)-indx(2), 1);   
Gr4 = repmat('ber 60 Jahre', indx(4)-indx(3), 1);  
klassen = strvcat(Gr1,Gr2,Gr3,Gr4);
gruppe = cellstr(klassen);
      
% Neudefinition der Stichprobenwerte ALS VEKTOR fr die Funktion anova1     
      
dbv = [dbvK1; dbvK2; dbvK3; dbvK4];      
      

% Aufruf der Funktion

[pWert, AnovTab, TestStatistik] = anova1B(dbv, gruppe)