% Script-File BspAnova2.m
%
% Aufruf:  BspAnova2
%
% Beispiel zur ZWEIFACHEN Varianzanalyse. Das Beispiel entstammt dem Buch von 
% Kreyszig (Gewichstzunahme bei einer Schweinemast)
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 15.6.2003


% Definition der Werte der Gewichtszunahmen. Die untersuchten Einflussgren sind
% Anfangsgewicht der Schweine vor der Mast (4 Klassen) und die Futterart (3 Klassen).
% Die Daten sind bezglich der Futterart SPALTENWEISE organisiert. Die einzelnen Zeilen
% entsprechen der Klassifikation nach Anfangsgewicht. Es wird bezglich jeder Kombination
% (Gewicht, Futter) nur ein Schwein getestet.
% 
% Untersuchtes Merkmal Futterart 
%          A       B       C
 
Gew =    [ 7.0,  14.0,    8.5;...    % Gewichtsklasse 1
          16.0,  15.5,   16.5;...    % Gewichtsklasse 2
          10.5,  15.0,    9.5;...    % Gewichtsklasse 3
          13.5,  21.0,   13.5];      % Gewichtsklasse 4

% Durchfhrung einer Varianzanalyse mit der Funktion anova2
% Aufruf der Funktion

wFaktor = 1;
[pWert, AnovTab, TestStatistik] = anova2B(Gew, wFaktor)