% Skript-File BspKruskalWallis1.m
%
% Aufruf:  BspKruskalWallis1
%
% Beispiel fr eine nichtparametrische Varianzanalyse fr einen balancierten
% Versuchsplan ohne Bindungen.
%
% Es wird fr eine Erhebung der Zahl der Fahrzeuge auf vier Ausfallstraen
% einer Stadt whrend der rush-hour Schritt fr Schritt ein Kruskal-Wallis-Test
% durchgefhrt.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 23.8.2003


% Tabelle der Anzahl der gezhlten Fahrzeuge

Anz = [3003  3201  422 3551; ...
       2967  3566 2233 3002; ...
        555  2455 2800 2678; ...
       3321  3012  217 3033; ...
       3122  3101 1533 2791];

% Dimension der Tabelle feststellen

DimAnz = size(Anz);

% Tabelle zu einer Spalte ordnen und sortieren

Anz = Anz(:);
[AnzSort, Indx] = sort(Anz);

% Spalte aller vorkommenden Rnge erzeugen

n = DimAnz(1)*DimAnz(2);
raenge = (1:DimAnz(1)*DimAnz(2))';

% Rnge entsprechend der in Indx gefundenen Anordnung
% sortieren und in die Form der ursprnglichen Matrix
% zurckfhren

[w, Indx2] = sort(Indx);
rangMat = reshape(raenge(Indx2), DimAnz);


% Rangsummen der Spalten berechnen und mit der Anzahl
% der Werte in jeder Spalte multiplizieren

rgSumMittel = sum(rangMat)/DimAnz(1);

% Testgre berechnen

Ttilde = DimAnz(1)*sum((rgSumMittel - (n+1)/2).^2)
T = 12*Ttilde/(n*(n+1))

% Kritische Schranke fr Testniveau alpha = 0.05

alpha = 0.05; k = DimAnz(2);
u_alpha = chi2invB(1-alpha, k-1)

% Testentscheidung 

H0 = (T>u_alpha)

% p-Wert

p = 1 - chi2cdfB(T, k-1)


