% Script-File BspUTest1.m
%
% Aufruf:  BspUTest1
%
% Beispiel zu Wilcoxon's U-Test (Rangsummentest). Vergleich der Punktzahlen
% von Klausuren einer Vorlesungsgruppe und einer Selbstlerngruppe.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 28.8.2003

% Erreichte Punktzahl der Vorlesungsgruppe

x = [  43  11  9   17  16  32  27  15  45  41 ...
       6   19  20  18  31  12  21  15   39  6 ...
       18  29  23  10  34  42  15  24   2  38];

% Erreichte Punktzahl der Selbstlerngruppe

y = [  45  10  50  11  13   2   9  17  21  46 ...
       5   18  22  10  11  10   8   5  30   9 ...
       28   9   7  14  36  2 ];

% Punkte in einem Vektor hintereinander schreiben und sortieren

n = length(x); m = length(y);
pkte = [x, y];
ranks = cumsum(ones(1,n+m));       % vorkommende Rnge
[psort, indx] = sort(pkte);        % aufsteigend sortierte Punkte

% Feststellen, wo die sortierten Werte sich ndern bzw.
% wo gleiche Werte auftreten

chng = sign([1, diff(psort)]); 

% zugehrige Rangziffern bestimmen

chgranks = ranks(logical(chng));
z = [ranks(logical(chng)), ranks(end)+1];   % Hilfsgre

% Durchschnittsrnge berechnen

dranks =(1/2)*(1./(z(2:end)-z(1:end-1))).*...
    ( z(2:end).*(z(2:end)-1) - z(1:end-1).*(z(1:end-1)-1));

% Rnge in ranks durch Durchschnittsrnge ersetzen

xdranks = [];
for k=2:length(z)
    xdranks = [xdranks, repmat(dranks(k-1), 1, z(k)-z(k-1))];
end;

% Zuordnung der Durchschnittsrnge zu den Vektoren x und y

ranksX = xdranks(indx<=n);
ranksY = xdranks(indx>n);

% Berechnung der Rangsummen

xrankSum = sum(ranksX);
yrankSum = sum(ranksY);

% Bestimmung des Werts der Testvariablen U

U = xrankSum -n*(n+1)/2;


% Zahl der Bindungen feststellen und Korrektursummand
% berechnen

rgdiff  = z(2:end)-z(1:end-1);
bindx = rgdiff>1;               % Index der Rangdifferenzen > 1
bindungen = rgdiff(bindx);      % Bindungen
K = length(bindungen);
                                % Korrektursummand bei Bindungen
korrekt = (sum(bindungen.^3)-sum(bindungen))/K;


% Bestimmung des kritischen Wertes
% (mit einseitigem alpha/2-Quantil der Normalverteilung
% bestimmen)


alpha = 0.05;
mu = n*m/2;
sigma = sqrt(n*m*(n+m+1)/12 - korrekt);
                                % Quantil der Standard-Normalverteilung
u_quantil =  norminvB(1-alpha/2);

k = floor( mu - u_quantil*sigma );


% Testentscheidung (1, falls Ablehnung, 0 sonst)

H = ~((U>k) & (U<n*m-k))