% Script-File Bspbootstrp.m
%
% Aufruf:  Bspbootstrp
%
% Beispiel zur Bootstrap-Technik. Schtzung des Modalwertes der Daten
% aus verbrauch.dat.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 19.12.2003

% Laden der Daten

load verbrauch.dat
dx = 0.1;
klmitten = (7.5:dx:11.5);    % Klassenmitten und Breiten dx def.

% Vorinitialisierung der empirischen Modalwerte
ModW = []; 

% Zahl der Experimente und Ziehungen definieren

M = 200;
N = length(verbrauch);     % Immer alle Elemente der Grundgesamtheit

% Initialisierung des Zufallsgenerators

rand('state',sum(100*clock));    

% M Ziehungen durchfhren und Modalwert berechnen

for k=1:M
    % Ziehung von N Elementen
    indx = unidrndB(N,1,N);
    stprob = verbrauch(indx);
    
    % Modalwert berechnen und hinzufgen
    ModW = [ModW, EmpModal(stprob, klmitten)]; 
end;

% Zweiseitige alpha-Quantile der Modalwerte berechnen

alpha = 0.05;

Gu = prctileB(ModW,100*alpha/2)
Go = prctileB(ModW,100*(1-alpha/2))