% Script-File BspsumGeoV.m
%
% Aufruf:  BspsumGeoV
%
% Berechnung und Plot der Summenverteilung von n
% geometrisch verteilten Zufallsvariablen. Mit diesem Skript
% kann die Aussage des Zentralen Grenzwertsatzes illustriert werden.
% Die approximierende Normalverteilung wird mit geplottet.
%
% Die Verteilung der Summenvariablen wird durch die Funktion 
% sumGeoV berechnet.
%
% Die Parameter n (gro!) und p mssen vor einem Lauf innerhalb des
% Skripts editiert werden.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.03.2003/27.6.2004

n = 200; p = 0.3;                  % Parameter hier editieren
[verteilung] = sumGeoV(p, n);
set(gca, 'FontSize', 14);

% Plot der approximierenden Normalverteilung
% (Zentraler Grenzwertsatz!) in die Grafik 
% Plot der Summenverteilung

bar((0:1:length(verteilung)-1), verteilung);
axis([0, length(verteilung), 0, max(verteilung)]);

hC = get(gca,'Children');
set(hC, 'FaceColor', [0.50,0.50,0.50])
set(hC, 'EdgeColor', [0.60,0.60,0.60])

hold
[M,V] = geostatB(p);                  % Mittelwert und Varianz der
                                      % geometrischen Verteilung bestimmen
x = (0:1:length(verteilung)-1);
y = normpdfB(x, n*M, sqrt(n*V));      % Normalverteilung berechnen

plot(x,y,'r-','LineWidth',5);
mx = max(max(y),max(verteilung));

% Darstellung innerhalb der 4sigma-Grenzen
axis([n*M-4*sqrt(n*V),n*M+4*sqrt(n*V)-1,0,mx])

% Achsenbeschriftung
xlabel('x', 'FontSize', 14);
ylabel('Summenverteilung und f_{NV}(x)', 'FontSize', 14);


